<?xml version="1.0"?>
<!--
    $Id: manage_user.xsl,v 1.4 2007-09-19 14:54:21 jakub Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:php="http://php.net/xsl">

  <xsl:import href="include.xsl"/>

  <xsl:variable name="userid" select="string($input/data/@userid)"/>
  <xsl:variable name="user_form" select="$input/subtree[@name = 'user']"/>

  <xsl:template name="insert-body">
    <h3>Access management (logins).</h3>

    <form name="userForm" method="post">
      <input type="hidden" name="page" value="{$page}"/>
      <input type="hidden" name="action" value="nop"/>
      <input type="hidden" name="userid" value="null"/>

      <xsl:choose>
        <xsl:when test="$action = 'edituser'">
          <br/>
          <b>Edit user:</b>
          <br/>
          <br/>
          <xsl:choose>
            <xsl:when test="$user_form">
              <xsl:call-template name="insert-user-form">
                <xsl:with-param name="user" select="$user_form/*"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="insert-user-form">
                <xsl:with-param name="user"
                      select="php:function('get_user_data', $userid)/*"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>

        <xsl:when test="$action = 'adduser'">
          <br/>
          <b>Add a new user:</b>
          <br/>
          <br/>
          <xsl:call-template name="insert-user-form">
            <xsl:with-param name="user" select="/*/defaultUser"/>
          </xsl:call-template>
        </xsl:when>

      </xsl:choose>
  
      <!-- not valid any more
      <xsl:call-template name="insert-group-selector">
        <xsl:with-param name="groups"
            select="php:function('get_groups_list_sel_user_id', $userid)/*"/>
      </xsl:call-template>
      -->

    </form>

  </xsl:template>

  <xsl:template name="insert-user-form">
    <xsl:param name="user"/>
    <table>
      <tr>
        <td><b>Full user name:</b></td>
        <td><input type="text" name="user[name]" value="{$user/@name}" /></td>
      </tr>
      <tr>
        <td><b>Institution:</b></td>
        <td><input type="text" name="user[institution]"
               value="{$user/@institution}" /></td>
      </tr>
      <tr>
        <td><b>E-mail:</b></td>
        <td><input type="text" name="user[email]" value="{$user/@email}" /></td>
      </tr>
      <tr>
        <td><b>Login name:</b></td>
        <td><input type="text" name="user[login]" value="{$user/@login}" /></td>
      </tr>
      <tr>
        <td><b>Password:</b></td>
        <td><input type="text" name="user[pass]" value="{$user/@pass}" /></td>
      </tr>
      <tr>
        <td><b>Custom OpenURL resolver:</b></td>
        <td><input type="text" name="user[ourl_resolver]" value="{$user/@ourl_resolver}" /></td>
      </tr>
      <tr>
        <td><b>Remember last selection:</b></td>
        <td>
            <input type="checkbox" name="user[sel_enabled]">
              <xsl:if test="$user/@sel_enabled = '1'">
                 <xsl:attribute name="checked">checked</xsl:attribute>
              </xsl:if>
            </input>
        </td>
      </tr>
      <tr>
        <td><b>Access group:</b></td>
        <td>
          <select name="user[group_id]">
            <option value="">- Select group</option>
            <xsl:for-each select="php:function('get_groups_list')/*/*">
              <option value="{@id}">
                <xsl:if test="$user/@group_id = @id">
                  <xsl:attribute name="selected">selected</xsl:attribute>
                </xsl:if>
                <xsl:value-of select="@name"/>
              </option>
            </xsl:for-each>
          </select>
        </td>
      </tr>

      <tr>
        <td colspan="3">
          <br/>
          <input type="button" value="Save" 
            onclick="set_action(document.userForm, 'saveuser', '{$userid}' )"/>
          
          <xsl:if test="$action!='adduser'">
            <input type="button" value="Delete"
              onclick="set_action(document.userForm, 'deleteuser', {$userid} )"/>
          </xsl:if>

          <input type="button" value="Cancel"
             onclick="set_action(document.userForm, 'switchpage')"/>
        </td>
      </tr>

    </table>
  </xsl:template>

  
</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
