<?xml version="1.0"?>
<!--
    $Id: manage_targets.xsl,v 1.3 2007-09-27 11:52:22 sondberg Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:php="http://php.net/xsl">

  <xsl:import href="include.xsl"/>

  <xsl:template name="insert-body">
    <h3>Resource management.</h3>

    <form name="targetForm" method="post">
      <input type="hidden" name="page" value="{$page}"/>
      <input type="hidden" name="action" value="nop"/>
      <input type="hidden" name="targetid" value="null"/>
      
      <xsl:call-template name="insert-target-list"/>

    </form>

  </xsl:template>

  <xsl:template name="insert-target-list">
      
    <br/>
    <b>Stored resources: </b>
    <br/>
    <br/>

    <input type="button" value="Add resource"
          onclick="set_action(document.targetForm, 'addtarget', 0)"/>
    <br/><br/>

    <table cellspacing="0" cellpadding="0">
      
      <xsl:for-each select="php:function('get_target_list')/*/*">
        <tr>
          <xsl:if test="position() mod 2 = 1">
            <xsl:attribute name="style">background: lightgrey;</xsl:attribute>
          </xsl:if>
          <td>
            <xsl:value-of select="@name" />
          </td>
          <td>
            <xsl:choose>
              <xsl:when test="string-length(@conn_string) &gt; 50">
                <xsl:value-of select="substring(@conn_string, 1, 50)"/>&#xa0;...
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="@conn_string"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td>
            <input type="button" value="Edit"
                     onclick="set_action(document.targetForm, 'edittarget',
                                         '{@id}')" />
          </td>
          <td>
            <input type="button" value="Delete"
                     onclick="set_action(document.targetForm, 'deletetarget',
                                         '{@id}')" />
          </td>
        </tr>
      </xsl:for-each>

    </table>
    
    <br/>
    <input type="button" value="Add resource"
      onclick="set_action(document.targetForm, 'addtarget', 0)"/>

  </xsl:template>


</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
