<?xml version="1.0"?>
<!--
    $Id: manage_ccl.xsl,v 1.2 2007-05-23 18:07:43 jakub Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:php="http://php.net/xsl">

  <xsl:import href="include.xsl"/>

  <xsl:variable name="cclmap_id" select="string($input/data/@cclmap_id)"/>
  <xsl:variable name="cclmap_form" select="$input/subtree[@name = 'cclmap']"/>

  <xsl:template name="insert-body">
    <h3>CCL mapping management.</h3>

    <form name="cclForm" method="post">
      <input type="hidden" name="page" value="{$page}"/>
      <input type="hidden" name="action" value="nop"/>
      <input type="hidden" name="cclmap_id" value="null"/>

      <xsl:choose>
        <xsl:when test="$action = 'editcclmap'">
          <br/>
          <b>Edit mapping:</b>
          <br/>
          <br/>
          <xsl:choose>
            <xsl:when test="$cclmap_form">
              <xsl:call-template name="insert-ccl-map">
                <xsl:with-param name="cclmap" select="$cclmap_form/*"/>
              </xsl:call-template>
            </xsl:when>

            <xsl:otherwise>
              <xsl:call-template name="insert-ccl-map">
                <xsl:with-param name="cclmap"
                    select="php:function('get_ccl_map', $cclmap_id)/*"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>

        <xsl:when test="$action = 'addcclmap'">
          <br/>
          <b>Add a new mapping:</b>
          <br/>
          <br/>
          <xsl:call-template name="insert-ccl-map">
            <xsl:with-param name="cclmap"
              select="/*/defaultCclmap"/>
          </xsl:call-template>
        </xsl:when>
        
        <xsl:otherwise>
          <xsl:call-template name="insert-ccl-map-overview"/>
        </xsl:otherwise>

      </xsl:choose>

    </form>
  </xsl:template>


  <xsl:template name="insert-ccl-map">
    <xsl:param name="cclmap"/>

    <p>
      CCL map name: <input type="text" name="cclmapname"
                                        value="{$cclmap/@name}"/>
    </p>

    <table>
      <tr>
        <td><b>CCL</b></td>
        <td><b>PQF</b></td>
        <td>&#xa0;</td>
      </tr>

      <xsl:for-each select="$cclmap/data">
        <xsl:call-template name="insert-ccl-spec"/>
      </xsl:for-each>

      <xsl:call-template name="insert-ccl-spec">
        <xsl:with-param name="id" select="'new_1'"/>
      </xsl:call-template>
      <xsl:call-template name="insert-ccl-spec">
        <xsl:with-param name="id" select="'new_2'"/>
      </xsl:call-template>
      <xsl:call-template name="insert-ccl-spec">
        <xsl:with-param name="id" select="'new_3'"/>
      </xsl:call-template>

      <tr>
        <td colspan="3">
          <br/>
          <input type="button" value="Save"
                   onclick="set_action(document.cclForm, 'savecclmap',
                                       '{$cclmap_id}')" />

          <xsl:if test="$action = 'editcclmap'">
            <input type="button" value="Delete"
                   onclick="set_action(document.cclForm, 'deletecclmap',
                                       '{$cclmap_id}')" />
          </xsl:if>

          <input type="button" value="Cancel"
                 onclick="set_action(document.cclForm, 'switchpage')" />
        </td>
      </tr>

    </table>
  </xsl:template>

  <xsl:template name="insert-ccl-spec">
    <xsl:param name="id" select="@id"/>
    
    <tr>
      <td><input app="ccl" type="text" name="cclmap[{$id}][ccl]"
                 value="{@cclqual}"/></td>
      <td><input app="pqf" type="text" name="cclmap[{$id}][pqf]"
                 value="{@pqf}"/></td>
      <td>
        <input type="button" value="Delete" onclick="remove_ccl_spec(this)"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template name="insert-ccl-map-overview">

    <br/>
    <b>Stored mappings:</b>
    <br/>
    <br/>
    
    <input type="button" value="Add mapping" 
      onclick="set_action(document.cclForm, 'addcclmap')"/>
    <ul>
      <xsl:for-each select="php:function('get_ccl_maps')/*/*">
        <li>
          <xsl:value-of select="@name"/>
          <input type="button" value="Edit"
                onclick="set_action(document.cclForm, 'editcclmap', '{@id}')"/>
          <input type="button" value="Delete"
                onclick="set_action(document.cclForm, 'deletecclmap','{@id}')"/>
        </li>
      </xsl:for-each>
    </ul>
    <input type="button" value="Add mapping" 
      onclick="set_action(document.cclForm, 'addcclmap')"/>
  </xsl:template>

</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
