<?xml version="1.0"?>
<!--
    $Id: manage_cats.xsl,v 1.2 2007-05-23 18:07:43 jakub Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:php="http://php.net/xsl">

  <xsl:import href="include.xsl"/>

  
  <xsl:variable name="parentid" select="string($input/data/@parentid)"/>
  <xsl:variable name="catid" select="string($input/data/@catid)"/>
  <xsl:variable name="cat_form" select="$input/subtree[@name = 'cat']"/>
  
  <xsl:template name="insert-body">
    <h3>Category management.</h3>
 
    <form name="catForm" method="post">
      <input type="hidden" name="page" value="{$page}"/>
      <input type="hidden" name="action" value="nop"/>
      <input type="hidden" name="catid" value="null"/>
      <input type="hidden" name="parentid" value="{$parentid}"/>
      
      <xsl:choose>

        <xsl:when test="$action = 'editcat'">
          <br/>
          <b>Edit category:</b>
          <br/><br/>
          <xsl:choose>

            <xsl:when test="$cat_form">
              <xsl:call-template name="insert-cat-data">
                <xsl:with-param name="cat" select="$cat_form/*"/>
              </xsl:call-template>
            </xsl:when>

            <xsl:otherwise>
              <xsl:call-template name="insert-cat-data">
                <xsl:with-param name="cat"
                   select="php:function('get_category_data', $catid)/*"/>
              </xsl:call-template>
            </xsl:otherwise>

          </xsl:choose>
        
        </xsl:when>

        <xsl:when test="$action = 'addcat'">
          <br/>
          <b>Add category:</b>
          <br/><br/>
          <xsl:call-template name="insert-cat-data">
            <xsl:with-param name="cat" select="/*/defaultCat"/>
          </xsl:call-template>
        </xsl:when>

        <!-- Categories tree page -->
        <xsl:otherwise>
          <br/>
          <b>Defined categories:</b>
          <br/><br/>
          <input type="button" value="Add rootcat" 
            onclick="set_action(document.catForm, 'addcat', '0')"/>
                    
          <ul>
            <xsl:for-each select="php:function('get_category_tree')/*">
              <xsl:call-template name="insert-cat-tree">
                <xsl:with-param name="cats"
                  select="."/>
              </xsl:call-template>
            </xsl:for-each>
          </ul>

          <input type="button" value="Add rootcat" 
            onclick="set_action(document.catForm, 'addcat', '0')"/>
        
        </xsl:otherwise>

      </xsl:choose>
      
    </form>
  
  </xsl:template>

  <xsl:template name="insert-cat-tree">
    
    <xsl:param name="cats"/>

    <xsl:for-each select="$cats/*">
      
      <li>
        <xsl:value-of select="@name"/>
          <input type="button" value="Add subcat" 
            onclick="set_action(document.catForm, 'addcat', '{@id}')"/>
          <input type="button" value="Edit" 
            onclick="set_action(document.catForm, 'editcat', '{@id}')"/>
          <!--leaf node buttons-->
          <xsl:if test="not(category)">
            <input type="button" value="Delete" 
              onclick="set_action(document.catForm, 'deletecat', '{@id}')"/> 
          </xsl:if>
      </li>
      <xsl:if test="category">
        <ul>
          <xsl:call-template name="insert-cat-tree">
            <xsl:with-param name="cats"
              select="."/>
          </xsl:call-template>
        </ul>
      </xsl:if>
    
    </xsl:for-each>
  
  </xsl:template>

  <xsl:template name="insert-cat-data">
    <xsl:param name="cat"/>
    <table>
      <tr>
        <td><b>Category name:</b></td>
        <td><input type="text" name="category[name]" value="{$cat/@name}" /></td>
      </tr>
      <tr>
        <td colspan="3">
          <br/>
          <input type="button" value="Save" 
            onclick="set_action(document.catForm, 'savecat', '{$catid}' )"/>
          
          <xsl:if test="$action!='addcat'">
            <input type="button" value="Delete"
              onclick="set_action(document.catForm, 'deletecat', {$catid} )"/>
          </xsl:if>

          <input type="button" value="Cancel"
             onclick="set_action(document.catForm, 'switchpage')"/>
        </td>
      </tr>
    </table>

  </xsl:template>


</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
