<?php
require_once 'includes.php';

/* $Id: index.php,v 1.4 2008-01-18 12:02:37 sondberg Exp $
 * --------------------------------------------------------------------------
 * The main script - this dispatches control to page handers, action handlers
 * and finally to an xslt stylesheet.
 */

main($_REQUEST);

function main (&$r) 
{
    global $config_file;
    $max_iterations = 5;
    $iter = 0;

    if (!isset($r['debug'])) {
        $r['debug'] = false;
    }

    if ($r['debug']) {
        echo "REQUEST:<pre>";
        print_r($r);
        echo "</pre>";
    }

    if (!isset($r['page'])) {
        $r['page'] = 'index';
    }

    if (!isset($r['action'])) {
        $r['action'] = 'nop';
    }
    
    $xml_config = new DOMDocument;
    $xml_config->load($config_file);

    $r['config_dom'] = $xml_config;
    $r['pending'] = array($r['page']);
    
    for ( $p = array_shift($r['pending']);
          $p && $iter < $max_iterations;
          $p = array_shift($r['pending']), $iter++ ) {

        $page_handler = 'page_handler_' . $p;

        if (!function_exists($page_handler)) {
            exception(__FILE__, 'Page handler ' . $page_handler . ' not yet '.
                    'implemented');
        }

        $proc = get_xsltproc_by_page($p);
        $page_handler(&$r, $proc);
    }
    
    insert_data($xml_config, $r);
    
    if (false) {
        echo "XML_CONFIG:<pre>", htmlentities($xml_config->saveXML()), "<pre>";
    }
    
    $doc = $proc->transformToDoc($xml_config);
    $doc->formatOutput = true;
    echo $doc->saveXML();
}

