<?php
class MappingData extends DOMDocument
{
    public function __construct($mapId)
    {
        parent::__construct('1.0', 'utf-8');
        $root = $this->appendChild( new DOMElement('mapspecs') );
        
        $c = new Criteria();
        $c->add(CclSpecPeer::CCL_MAP_ID, $mapId);
        
        $mapSpecs = CclSpecPeer::doSelectJoinCclmap($c);

        $root->setAttribute('name',
                            $mapSpecs[0]->getCclMap()->getCclMapName());
            
        foreach($mapSpecs as $mapSpec) {
            $specNode = $root->appendChild( new DOMElement('data') );
            $specNode->setAttribute( 'id', $mapSpec->getCclSpecId() );
            $specNode->setAttribute( 'cclqual', $mapSpec->getCclQual() );
            $specNode->setAttribute( 'pqf', $mapSpec->getPqf() );
        }
    }
}
