<?php
class IpMasksList extends DOMDocument
{
    public function __construct()
    {
        $c = new Criteria();
        $c->addAscendingOrderByColumn(IpMaskPeer::MASK_NAME);
        $ipmasks = IpMaskPeer::doSelect($c);

        parent::__construct('1.0', 'utf-8');
        $root = $this->appendChild( new DOMElement('ipmasks') );

        foreach ($ipmasks as $ipmask){
            $ipmaskNode = $root->appendChild( new DOMElement('ipmask') );
            $ipmaskNode->setAttribute( 'id', $ipmask->getMaskId() );
            $ipmaskNode->setAttribute( 'name', $ipmask->getMaskName() );
            $ipmaskNode->setAttribute( 'lower', $ipmask->getMaskLower() );
            $ipmaskNode->setAttribute( 'upper', $ipmask->getMaskUpper() );
        }
    }
}
