<?php
require_once 'php/classes/Pz2Wrapper.class.php';
require_once 'Pz2Settings.class.php';
require_once 'Auth.class.php';
require_once 'php/includes/propel_init.php';
require_once 'propel/Propel.php';

class Pz2WrapperAuth extends Pz2Wrapper
{
    private $auth;

    public function __construct ( $url )
    {
        parent::__construct($url);
        $this->auth = new Auth();
    }

    public function restart ()
    {
        if ( ( $policy = mk_session_read('policy') ) 
            && $this->auth->authByPolicy( $policy ) )
        {
                $this->init(true);
                $targets = $this->auth->authorize();
                $pz2setts = new Pz2Settings();
                $pz2setts->populate($targets);
                $this->setUp( $pz2setts );

        } else {
            throw new Exception('Not authenticated.', 101 );
        }

        return $this->sessionId;
    }

    private function setUp ( $settings )
    {
        $this->checkResponse( $this->pz2Url
                . '?command=settings&session='
                . $this->sessionId,
                $settings->getSettings() );
    }
}
