<?php
error_reporting(E_ALL);


if (isset($_SERVER["MASTERKEY_PATH"]))
    set_include_path( $_SERVER['MASTERKEY_PATH']
		      . PATH_SEPARATOR . get_include_path() );
elseif (isset($_SERVER["REDIRECT_MASTERKEY_PATH"]))
    set_include_path( $_SERVER['REDIRECT_MASTERKEY_PATH']
		      . PATH_SEPARATOR . get_include_path() );
else {
    echo "We screwed it up";
    var_dump($_SERVER);
    throw new Exception('Masterkey path not set.');
}

require_once 'php/classes/ConfigFile.class.phpi';
if ( isset($_SERVER['PATH_TRANSLATED']) ) {
    $mk_config = new ConfigFile($_SERVER['PATH_TRANSLATED']);
} else {
    php_error('No XML file for masterkey shell');
}

$mk_config->write('gui_path', dirname($_SERVER['PATH_TRANSLATED']));

mk_run($mk_config, $_REQUEST, $_SERVER);

function mk_run ($conf, &$req, &$serv)
{
    if (isset($req['command'])) {
	switch($req['command']) {
	case 'login':
	case 'check':
	case 'tree':
	case 'handshake':
	    require_once 'php/includes/propel_init.php';
	    require_once 'php/classes/auth/AuthWS.class.php';
	    session_start();
	    
	    if ( isset($serv['HTTP_X_FORWARDED_FOR']) ) {
		$req['ipaddr'] = $serv['HTTP_X_FORWARDED_FOR'];
	    } else if ( isset($serv['REMOTE_ADDR']) ) {
		$req['ipaddr'] = $serv['REMOTE_ADDR'];
	    }
	    
	    $ws = new AuthWS($req, $_SESSION);
	    $ws->start();
	    $ws->sendResponse();	
	    break;
	case 'save':
	    require_once 'php/includes/propel_init.php';
	    require_once 'php/classes/auth/UserDataWS.class.php';
	    $ud = new UserDataWS($req);
	    $ud->save();
	    $ud->send_response();
	    break;
	case 'fetch':
	    require_once 'php/includes/propel_init.php';
	    require_once 'php/classes/auth/UserDataWS.class.php';
	    $ud = new UserDataWS($req);
	    $ud->fetch();
	    $ud->send_response();
	    break;
	default: // proxy stuff
	    require_once 'php/classes/Pz2Proxy.class.php';
	    require_once 'php/classes/Pz2WrapperFactory.class.php';
	    $pz2 = Pz2WrapperFactory::makeWrapper($conf);
	    $proxy = new Pz2Proxy( $req, $serv, $pz2);
	    $proxy->start();
	    $proxy->sendResponse();
	}
	exit;
    }
    mk_set_default_paths($conf);

    $lang = mk_prepare_lang_doc($conf, $req);
    $proc = mk_prepare_proc($conf, $req);

    echo $proc->transformToXML($lang);
}

function resolve_include_path ($filename)
{
    $paths = explode( PATH_SEPARATOR, get_include_path() );
    foreach( $paths as $path ) {
        if ( file_exists( $path.'/'.$filename) )
            return $path;
    }
}

function mk_prepare_proc ($conf, $r) 
{
    $core_path = resolve_include_path('xsl/mk_front.xsl');
    $conf->write('core_path', $core_path);
    
    if ( $conf->read('gui_front_xsl') )
        $front_xsl_path = $conf->read('gui_path').'/'.$conf->read('gui_front_xsl');
    else
	$front_xsl_path = $core_path.'/xsl/mk_front.xsl';
    
    $xsl = new DOMDocument;
    $xsl->load($front_xsl_path);

    $xsl->saveXML();

    $proc = new XSLTProcessor;
    $proc->importStyleSheet($xsl);
    
    return $proc;
}

function mk_prepare_lang_doc ($conf, $r)
{
    if( isset($r["lang"]) ) {
        $lang = $r['lang'];
    } else {
        $lang = 'en';
    } 

    /* load language file */
    $xml_lang = new DOMDocument;

    
    $locale_path = $conf->read('gui_path') . '/locale';
    if (!is_dir($locale_path))
      die("Locale path '" . $locale_path . "' does not exists");

    load_lang_to_doc($xml_lang, $lang, $locale_path);
    
    append_content_from_file($xml_lang, 'about', $lang, $locale_path);
    append_content_from_file($xml_lang, 'help', $lang, $locale_path);
    
    $avail_lang = get_languages($lang, $locale_path );
    append_content_from_doc($xml_lang, $avail_lang);
    append_content_from_doc($xml_lang, $conf);
    
    return $xml_lang;
}

function mk_set_default_paths ($conf)
{
    
    if( ! $conf->read('jquery_uri') )
        $conf->write('jquery_uri', '/jquery');

    if( ! $conf->read('pz2js_uri') )
        $conf->write('pz2js_uri', '/pazpar2/js/pz2.js');

    if( ! $conf->read('masterkey_core_uri') )
        $conf->write('masterkey_core_uri', '/masterkey-core');

    if( ! $conf->read('masterkey_auth_uri') )
        $conf->write('masterkey_auth_uri', '/masterkey-auth');

}


function get_languages ($current_lang, $dir) {
    $xml = '';

    if ( $dh = opendir($dir)) {
        while (($entry = readdir($dh)) !== false) {
            if ( preg_match('/front-(..)\.xml/', $entry, $match) ) {
                if ($match[1] == $current_lang) {
                    $selected = ' selected="true"';
                } else {
                    $selected = '';
                }
                $langfile = ' file="'.$entry.'"';
                $xml .= "<lang$selected$langfile>".$match[1]."</lang>";
            }
        }
        
        closedir($dh);
    }
    
    $xml = "<languages>" . $xml . "</languages>";
    $doc = new DOMDocument;
    $doc->loadXml($xml);
    return $doc;
}

function load_lang_to_doc ( &$xml, $langcode, $path ) 
{
    if ( preg_match('/^[a-z]{2}$/', $langcode) ) {
        $full_path = $path . '/front-' . $langcode . '.xml';

        if ( file_exists($full_path) ) {
            $xml->load($full_path);
        } else {
            die("Language: '" . $langcode . "' currently not enabled"
                . " because file '" . $full_path . "' could not be loaded");
        }
    } else {
        die('Only 2 letter language codes');
    }
}

function append_content_from_file ( &$xml, $file, $lang, $path) 
{
    $filepath = $path.'/'.$file.'-'.$lang.'.xml';
    
    if ( !file_exists($filepath) )
        die($filepath. ' is missing.');
    
    $content_doc = new DOMDocument();
    $content_doc->load($filepath);
    
    append_content_from_doc ($xml, $content_doc);
}

function append_content_from_doc (&$toXML, &$fromXML)
{
    $nodeCopy = $toXML->importNode(
                $fromXML->documentElement,
                true);

    $toXML->documentElement->appendChild($nodeCopy);
}

function mk_session_read ( $key )
{
    @session_start();
    if ( !isset( $_SESSION['auth'][$key]) )
        return false;
    $value = $_SESSION['auth'][$key];
    session_write_close();
    return $value;
}

function mk_session_write ( $key, $value )
{
    @session_start();
    $_SESSION['auth'][$key] = $value;
    session_write_close();
}
