/* $Id: mkState.class.js,v 1.2 2007-10-08 13:21:11 jakub Exp $ */
/* Serializable state object */

var mkState = function()
{
    this.sort = 'relevance';
    this.perPage = 20;
    this.page = 0;
    this.simpleQuery = '';
    this.singleFilter = null;
    this.advTerms = new Array();
    this.numTerms = 0;
    this.action = '';
};

mkState.prototype = 
{
    reset: function()
    {
        this.simpleQuery = '';
        this.advTerms = new Array();
        this.simpleFilter = null;
        this.numTerms = 0;
    },
    
    clearSimpleQuery: function()
    {
        this.simpleQuery = '';
    },
    
    addTerm: function(field, value)
    {
        var term = {"field": field, "value": value};
        this.advTerms[this.numTerms] = term;
        this.numTerms++;
    },
    
    getTermValueByIdx: function(index)
    {
        return this.advTerms[index].value;
    },
    
    getTermFieldByIdx: function(index)
    {
        return this.advTerms[index].field;
    },
    
    /* semicolon separated list of terms for given field*/
    getTermsByField: function(field)
    {
        var terms = '';
        for(var i = 0; i < this.advTerms.length; i++)
        {
            if( this.advTerms[i].field == field )
                terms = terms + this.queryHas[i].value + ';';
        }
        return terms;
    },
    
    addTermsFromList: function(inputString, field)
    {
        var inputArr = inputString.split(';');
        for(var i=0; i < inputArr.length; i++)
        {
            if(inputArr[i].length < 3) continue;
            this.advTerms[this.numTerms] 
                = {"field": field, "value": inputArr[i] };
            this.numTerms++;
        }
    },
    
    removeTermByIdx: function(index)
    {
        this.advTerms.splice(index, 1);
        this.numTerms--;
    },
    
    toCCL: function()
    {   
        var ccl = '';
        if( this.simpleQuery != '')
            ccl = this.simpleQuery;
        for(var i = 0; i < this.advTerms.length; i++)
        {
            if (ccl != '') ccl = ccl + ' and ';
            ccl = ccl + this.advTerms[i].field
                +'=('+this.advTerms[i].value+')';
        }
        return ccl;
    },
    
    totalLength: function()
    {
        var simpleLength = this.simpleQuery != '' ? 1 : 0;
        return this.advTerms.length + simpleLength;
    },
    
    clearSingleFilter: function()
    {
        this.singleFilter = null;
    },
    
    setSingleFilter: function(name, value)
    {
        this.singleFilter = {"name": name, "id": value };
    },
    
    getSingleFilterName: function()
    {
        return this.singleFilter.name;
    },

    getSingleFilterString: function()
    {
        if( this.singleFilter != null ) {
            return 'pz:id='+this.singleFilter.id;
        } else {
            return undefined;
        }
    }
}
