var Bool = function () 
{
    this.isEmpty = true;
}

var ResourceSelect = function ( params )
{
    if (typeof params != 'object' )
        throw new Error ('Requires a hash with parameters!');

    this._placeHolder = document.getElementById( params['divId'] );
    this._server = params['userDataWS'] || '.';

    this._saved_selection = {};
    this._sel_enabled = false;
    this.data = null;
    
}

ResourceSelect.prototype = 
{
    fetchSelection: function ( data )
    {
        this._saved_selection = {};
        this._sel_enabled = false;
        var context = this;
        var sel_req = new pzHttpRequest(this._server);
        sel_req.get(
            {"command" : "fetch", "attrs" : "selection,sel_enabled" },
            function (response) 
            {
                // try to fetch previous selection
                // this will fail for ipauth
                context.loaded = true;
                if ( response.getElementsByTagName('status')[0]
                        .firstChild.nodeValue == 'OK' ) {
                    var selection =  response
                                        .getElementsByTagName('user')[0]
                                        .getAttribute('selection');
                    
                    var sel_enabled =  response
                                        .getElementsByTagName('user')[0]
                                        .getAttribute('sel_enabled');

                    if (selection && sel_enabled) {
                        context._saved_selection = $.parseJSON(selection);
                        context._sel_enabled = true;
                    }
                }
                
                //when the fetching of previous selection is done, 
                //build the tree
                if (data != undefined){
                    context.build(data);
                }
            }
        );
    },

    build: function ( data )
    {
        var ph = $(this._placeHolder);
        ph.empty();
        
        var catTree = this._buildTree( data, new Bool() );
    
        catTree.addClass('dir')
            .appendTo(ph)
            .Treeview();
    },

    _buildTree: function ( data, currentBool  )
    {
        var catsUl = $('<ul></ul>');
    
        if (data) {
            for(var i = 0; i < data.length; i++) {
                
                var catId = 'catid_' + data[i]["catid"]; 
                var catLi = $('<li id="' + catId + '" class="closed"/>');
                
                var cInp = $('<input type="checkbox"/>');

                var context = this;
                cInp.click ( function () { context.checkCategory(this); } );

                catLi.append(cInp);
                catLi.append('<b>' + data[i]["catname"] + '</b>');

                var childBool = new Bool();
                var subUl = this._buildTree( data[i]["subcats"], childBool );           
                 
                for( var j=0; j < data[i]["targets"].length; j++) {
                    
                    var tId = data[i]["targets"][j]["id"];
                    var tName = data[i]["targets"][j]["name"];
                    
                    childBool.isEmpty = false;

                    var tLi = $('<li id="' + tId +'"/>');
                    
                    var tInp = $('<input type="checkbox" class="targetCb" value="'
                                + tId +'"/>');

                    tInp.click( function() { context.checkTarClick(this); } );

                    tLi.append(tInp);
                    tLi.append(tName)
                    subUl.append(tLi);
                    
                    // also check if the target was selected prevoiusly
                    if ( this._saved_selection[catId]
                        && tId in this._saved_selection[catId] ) {
                        var tCb = tLi.children('input');
                        tCb.attr('checked','checked');
                        this.checkTarget( tCb[0], tName, catId);
                    }
                }
                
                if ( !childBool.isEmpty ) {
                    currentBool.isEmpty = false;
                    catLi.append(subUl);
                    catsUl.append(catLi);
                }
            }
        }

        if( !currentBool.isEmpty ) {
            return catsUl;
        } else {
            return $('<ul></ul>');
        }

    },

    checkCategory: function (catCheckbox)
    {
        var catId = catCheckbox.parentNode.getAttribute('id');
        var context = this;
        if( catCheckbox.checked == true ) {
            $(catCheckbox)
                .parent()
                .children('ul')
                .children('li')
                .children('input')
                .each( function(){
                        if ( this.checked == false ) {
                            this.checked = true;
                        if(this.className == 'targetCb')
                            context.checkTarget(this, 
                                this.nextSibling.nodeValue, catId);
                        else
                            context.checkCategory(this);
                        }
                    } );
        } else {
            $(catCheckbox)
                .parent()
                .children('ul')
                .children('li')
                .children('input')
                .each( function(){
                        if ( this.checked == true ) {
                            this.checked = false;
                        if(this.className == 'targetCb')
                            context.checkTarget(this, 
                                this.nextSibling.nodeValue, catId);
                        else
                            context.checkCategory(this);
                        }
                    } );
        }
        if (this._sel_enabled) this._sentSelection();
    },

    checkTarClick: function (tCb)
    {
        var catId = tCb.parentNode.parentNode.parentNode
            .getAttribute('id');
        this.checkTarget( tCb, tCb.nextSibling.nodeValue, catId );
        if (this._sel_enabled) this._sentSelection();
    },

    checkTarget: function (targetCheckbox, targetName, catId )
    {
        if( targetCheckbox.checked == true ) {
            targetCheckbox
                .setAttribute('filterpos', 
                    resFilters.addFilter(targetName, 
                                            targetCheckbox.value) );
                   
            if (typeof this._saved_selection[catId] != 'object') 
                this._saved_selection[catId] = {};
            this._saved_selection[catId][targetCheckbox.value] = true;

        } else {
            resFilters.removeFilter( targetCheckbox
                                        .getAttribute('filterpos') );
            targetCheckbox
                .removeAttribute('filterpos');
            
            if (targetCheckbox.value in this._saved_selection[catId]) 
                delete this._saved_selection[catId][targetCheckbox.value];
        }

    },


    _sentSelection: function ()
    {
        //sent the selection array to the server
        var sel_data = document.newXmlDoc('user');
        sel_data
            .documentElement
            .setAttribute( 'selection', 
                $.toJSON ( this._saved_selection ) );
        
        var req = new pzHttpRequest(this._server);
        req.post(
            {"command" : "save"},
            sel_data,
            function (response) 
            { 
                if ( response.getElementsByTagName('status')[0]
                        .firstChild.nodeValue != 'OK') {
                    //alert("There were problems saving data.");
                }
            }
        );
    }
}
