<?php

/**
 * Base class that represents a row from the 'z_auth' table.
 *
 * many 2 many rel. between targets and groups
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * Mon Nov 12 15:49:39 2007
 *
 * @package    masterkey.om
 */
abstract class BaseZAuth extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        ZAuthPeer
	 */
	protected static $peer;


	/**
	 * The value for the target_id field.
	 * @var        int
	 */
	protected $target_id;


	/**
	 * The value for the group_id field.
	 * @var        int
	 */
	protected $group_id;


	/**
	 * The value for the z_user field.
	 * @var        string
	 */
	protected $z_user;


	/**
	 * The value for the z_pass field.
	 * @var        string
	 */
	protected $z_pass;


	/**
	 * The value for the z_group field.
	 * @var        string
	 */
	protected $z_group;

	/**
	 * @var        Target
	 */
	protected $aTarget;

	/**
	 * @var        AccessGroup
	 */
	protected $aAccessGroup;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Get the [target_id] column value.
	 * 
		
	 * @return     int
	 */
	public function getTargetId()
	{

		return $this->target_id;
	}

	/**
	 * Get the [group_id] column value.
	 * 
		
	 * @return     int
	 */
	public function getGroupId()
	{

		return $this->group_id;
	}

	/**
	 * Get the [z_user] column value.
	 * Auth login
		
	 * @return     string
	 */
	public function getZUser()
	{

		return $this->z_user;
	}

	/**
	 * Get the [z_pass] column value.
	 * Auth password
		
	 * @return     string
	 */
	public function getZPass()
	{

		return $this->z_pass;
	}

	/**
	 * Get the [z_group] column value.
	 * Auth group
		
	 * @return     string
	 */
	public function getZGroup()
	{

		return $this->z_group;
	}

	/**
	 * Set the value of [target_id] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setTargetId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->target_id !== $v) {
			$this->target_id = $v;
			$this->modifiedColumns[] = ZAuthPeer::TARGET_ID;
		}

		if ($this->aTarget !== null && $this->aTarget->getTargetId() !== $v) {
			$this->aTarget = null;
		}

	} // setTargetId()

	/**
	 * Set the value of [group_id] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setGroupId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->group_id !== $v) {
			$this->group_id = $v;
			$this->modifiedColumns[] = ZAuthPeer::GROUP_ID;
		}

		if ($this->aAccessGroup !== null && $this->aAccessGroup->getGroupId() !== $v) {
			$this->aAccessGroup = null;
		}

	} // setGroupId()

	/**
	 * Set the value of [z_user] column.
	 * Auth login
	 * @param      string $v new value
	 * @return     void
	 */
	public function setZUser($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->z_user !== $v) {
			$this->z_user = $v;
			$this->modifiedColumns[] = ZAuthPeer::Z_USER;
		}

	} // setZUser()

	/**
	 * Set the value of [z_pass] column.
	 * Auth password
	 * @param      string $v new value
	 * @return     void
	 */
	public function setZPass($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->z_pass !== $v) {
			$this->z_pass = $v;
			$this->modifiedColumns[] = ZAuthPeer::Z_PASS;
		}

	} // setZPass()

	/**
	 * Set the value of [z_group] column.
	 * Auth group
	 * @param      string $v new value
	 * @return     void
	 */
	public function setZGroup($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->z_group !== $v) {
			$this->z_group = $v;
			$this->modifiedColumns[] = ZAuthPeer::Z_GROUP;
		}

	} // setZGroup()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 * 
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default. 
	 * 
	 * @return    boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0)
	{
		try {

			$this->target_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->group_id = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
			$this->z_user = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->z_pass = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->z_group = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
			$this->resetModified();

			$this->setNew(false);

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 5; // 5 = ZAuthPeer::NUM_COLUMNS - ZAuthPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating ZAuth object", $e);
		}
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ZAuthPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			ZAuthPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.  If the object is new,
	 * it inserts it; otherwise an update is performed.  This method
	 * wraps the doSave() worker method in a transaction.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ZAuthPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			$affectedRows = $this->doSave($con);
			$con->commit();
			ZAuthPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aTarget !== null) {
				if ($this->aTarget->isModified() || $this->aTarget->isNew()) {
					$affectedRows += $this->aTarget->save($con);
				}
				$this->setTarget($this->aTarget);
			}

			if ($this->aAccessGroup !== null) {
				if ($this->aAccessGroup->isModified() || $this->aAccessGroup->isNew()) {
					$affectedRows += $this->aAccessGroup->save($con);
				}
				$this->setAccessGroup($this->aAccessGroup);
			}


			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ZAuthPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setNew(false);
				} else {
					$affectedRows += ZAuthPeer::doUpdate($this, $con);
				}
				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aTarget !== null) {
				if (!$this->aTarget->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aTarget->getValidationFailures());
				}
			}

			if ($this->aAccessGroup !== null) {
				if (!$this->aAccessGroup->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aAccessGroup->getValidationFailures());
				}
			}


			if (($retval = ZAuthPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(ZAuthPeer::DATABASE_NAME);

		if ($this->isColumnModified(ZAuthPeer::TARGET_ID)) $criteria->add(ZAuthPeer::TARGET_ID, $this->target_id);
		if ($this->isColumnModified(ZAuthPeer::GROUP_ID)) $criteria->add(ZAuthPeer::GROUP_ID, $this->group_id);
		if ($this->isColumnModified(ZAuthPeer::Z_USER)) $criteria->add(ZAuthPeer::Z_USER, $this->z_user);
		if ($this->isColumnModified(ZAuthPeer::Z_PASS)) $criteria->add(ZAuthPeer::Z_PASS, $this->z_pass);
		if ($this->isColumnModified(ZAuthPeer::Z_GROUP)) $criteria->add(ZAuthPeer::Z_GROUP, $this->z_group);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ZAuthPeer::DATABASE_NAME);

		$criteria->add(ZAuthPeer::TARGET_ID, $this->target_id);
		$criteria->add(ZAuthPeer::GROUP_ID, $this->group_id);

		return $criteria;
	}

	/**
	 * Returns the composite primary key for this object.
	 * The array elements will be in same order as specified in XML.
	 * @return     array
	 */
	public function getPrimaryKey()
	{
		$pks = array();

		$pks[0] = $this->getTargetId();

		$pks[1] = $this->getGroupId();

		return $pks;
	}

	/**
	 * Set the [composite] primary key.
	 *
	 * @param      array $keys The elements of the composite key (order must match the order in XML file).
	 * @return     void
	 */
	public function setPrimaryKey($keys)
	{

		$this->setTargetId($keys[0]);

		$this->setGroupId($keys[1]);

	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of ZAuth (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setZUser($this->z_user);

		$copyObj->setZPass($this->z_pass);

		$copyObj->setZGroup($this->z_group);


		$copyObj->setNew(true);

		$copyObj->setTargetId(NULL); // this is a pkey column, so set to default value

		$copyObj->setGroupId(NULL); // this is a pkey column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     ZAuth Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     ZAuthPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ZAuthPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a Target object.
	 *
	 * @param      Target $v
	 * @return     void
	 * @throws     PropelException
	 */
	public function setTarget(Target $v = null)
	{
		if ($v === null) {
			$this->setTargetId(NULL);
		} else {
			$this->setTargetId($v->getTargetId());
		}

		$this->aTarget = $v;


	}


	/**
	 * Get the associated Target object
	 *
	 * @param      PDO Optional Connection object.
	 * @return     Target The associated Target object.
	 * @throws     PropelException
	 */
	public function getTarget(PDO $con = null)
	{
		if ($this->aTarget === null && ($this->target_id !== null)) {
			$this->aTarget = TargetPeer::retrieveByPK($this->target_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aTarget->addZAuths($this);
			 */
		}
		return $this->aTarget;
	}

	/**
	 * Declares an association between this object and a AccessGroup object.
	 *
	 * @param      AccessGroup $v
	 * @return     void
	 * @throws     PropelException
	 */
	public function setAccessGroup(AccessGroup $v = null)
	{
		if ($v === null) {
			$this->setGroupId(NULL);
		} else {
			$this->setGroupId($v->getGroupId());
		}

		$this->aAccessGroup = $v;


	}


	/**
	 * Get the associated AccessGroup object
	 *
	 * @param      PDO Optional Connection object.
	 * @return     AccessGroup The associated AccessGroup object.
	 * @throws     PropelException
	 */
	public function getAccessGroup(PDO $con = null)
	{
		if ($this->aAccessGroup === null && ($this->group_id !== null)) {
			$this->aAccessGroup = AccessGroupPeer::retrieveByPK($this->group_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aAccessGroup->addZAuths($this);
			 */
		}
		return $this->aAccessGroup;
	}

} // BaseZAuth
