<?php

/**
 * Base class that represents a row from the 'ip_mask' table.
 *
 * Ip masks
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * Mon Nov 12 15:49:38 2007
 *
 * @package    masterkey.om
 */
abstract class BaseIpMask extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        IpMaskPeer
	 */
	protected static $peer;


	/**
	 * The value for the mask_id field.
	 * @var        int
	 */
	protected $mask_id;


	/**
	 * The value for the mask_name field.
	 * @var        string
	 */
	protected $mask_name;


	/**
	 * The value for the mask_lower field.
	 * @var        string
	 */
	protected $mask_lower;


	/**
	 * The value for the mask_upper field.
	 * @var        string
	 */
	protected $mask_upper;


	/**
	 * The value for the group_id field.
	 * @var        int
	 */
	protected $group_id;

	/**
	 * @var        AccessGroup
	 */
	protected $aAccessGroup;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Get the [mask_id] column value.
	 * Group Id
		
	 * @return     int
	 */
	public function getMaskId()
	{

		return $this->mask_id;
	}

	/**
	 * Get the [mask_name] column value.
	 * IP range name
		
	 * @return     string
	 */
	public function getMaskName()
	{

		return $this->mask_name;
	}

	/**
	 * Get the [mask_lower] column value.
	 * Lower range value
		
	 * @return     string
	 */
	public function getMaskLower()
	{

		return $this->mask_lower;
	}

	/**
	 * Get the [mask_upper] column value.
	 * Upper value
		
	 * @return     string
	 */
	public function getMaskUpper()
	{

		return $this->mask_upper;
	}

	/**
	 * Get the [group_id] column value.
	 * 
		
	 * @return     int
	 */
	public function getGroupId()
	{

		return $this->group_id;
	}

	/**
	 * Set the value of [mask_id] column.
	 * Group Id
	 * @param      int $v new value
	 * @return     void
	 */
	public function setMaskId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->mask_id !== $v) {
			$this->mask_id = $v;
			$this->modifiedColumns[] = IpMaskPeer::MASK_ID;
		}

	} // setMaskId()

	/**
	 * Set the value of [mask_name] column.
	 * IP range name
	 * @param      string $v new value
	 * @return     void
	 */
	public function setMaskName($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->mask_name !== $v) {
			$this->mask_name = $v;
			$this->modifiedColumns[] = IpMaskPeer::MASK_NAME;
		}

	} // setMaskName()

	/**
	 * Set the value of [mask_lower] column.
	 * Lower range value
	 * @param      string $v new value
	 * @return     void
	 */
	public function setMaskLower($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->mask_lower !== $v) {
			$this->mask_lower = $v;
			$this->modifiedColumns[] = IpMaskPeer::MASK_LOWER;
		}

	} // setMaskLower()

	/**
	 * Set the value of [mask_upper] column.
	 * Upper value
	 * @param      string $v new value
	 * @return     void
	 */
	public function setMaskUpper($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->mask_upper !== $v) {
			$this->mask_upper = $v;
			$this->modifiedColumns[] = IpMaskPeer::MASK_UPPER;
		}

	} // setMaskUpper()

	/**
	 * Set the value of [group_id] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setGroupId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->group_id !== $v) {
			$this->group_id = $v;
			$this->modifiedColumns[] = IpMaskPeer::GROUP_ID;
		}

		if ($this->aAccessGroup !== null && $this->aAccessGroup->getGroupId() !== $v) {
			$this->aAccessGroup = null;
		}

	} // setGroupId()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 * 
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default. 
	 * 
	 * @return    boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0)
	{
		try {

			$this->mask_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->mask_name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->mask_lower = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->mask_upper = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->group_id = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
			$this->resetModified();

			$this->setNew(false);

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 5; // 5 = IpMaskPeer::NUM_COLUMNS - IpMaskPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating IpMask object", $e);
		}
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(IpMaskPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			IpMaskPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.  If the object is new,
	 * it inserts it; otherwise an update is performed.  This method
	 * wraps the doSave() worker method in a transaction.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(IpMaskPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			$affectedRows = $this->doSave($con);
			$con->commit();
			IpMaskPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aAccessGroup !== null) {
				if ($this->aAccessGroup->isModified() || $this->aAccessGroup->isNew()) {
					$affectedRows += $this->aAccessGroup->save($con);
				}
				$this->setAccessGroup($this->aAccessGroup);
			}


			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = IpMaskPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setMaskId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += IpMaskPeer::doUpdate($this, $con);
				}
				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aAccessGroup !== null) {
				if (!$this->aAccessGroup->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aAccessGroup->getValidationFailures());
				}
			}


			if (($retval = IpMaskPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(IpMaskPeer::DATABASE_NAME);

		if ($this->isColumnModified(IpMaskPeer::MASK_ID)) $criteria->add(IpMaskPeer::MASK_ID, $this->mask_id);
		if ($this->isColumnModified(IpMaskPeer::MASK_NAME)) $criteria->add(IpMaskPeer::MASK_NAME, $this->mask_name);
		if ($this->isColumnModified(IpMaskPeer::MASK_LOWER)) $criteria->add(IpMaskPeer::MASK_LOWER, $this->mask_lower);
		if ($this->isColumnModified(IpMaskPeer::MASK_UPPER)) $criteria->add(IpMaskPeer::MASK_UPPER, $this->mask_upper);
		if ($this->isColumnModified(IpMaskPeer::GROUP_ID)) $criteria->add(IpMaskPeer::GROUP_ID, $this->group_id);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(IpMaskPeer::DATABASE_NAME);

		$criteria->add(IpMaskPeer::MASK_ID, $this->mask_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getMaskId();
	}

	/**
	 * Generic method to set the primary key (mask_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setMaskId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of IpMask (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setMaskName($this->mask_name);

		$copyObj->setMaskLower($this->mask_lower);

		$copyObj->setMaskUpper($this->mask_upper);

		$copyObj->setGroupId($this->group_id);


		$copyObj->setNew(true);

		$copyObj->setMaskId(NULL); // this is a pkey column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     IpMask Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     IpMaskPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new IpMaskPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a AccessGroup object.
	 *
	 * @param      AccessGroup $v
	 * @return     void
	 * @throws     PropelException
	 */
	public function setAccessGroup(AccessGroup $v = null)
	{
		if ($v === null) {
			$this->setGroupId(NULL);
		} else {
			$this->setGroupId($v->getGroupId());
		}

		$this->aAccessGroup = $v;


	}


	/**
	 * Get the associated AccessGroup object
	 *
	 * @param      PDO Optional Connection object.
	 * @return     AccessGroup The associated AccessGroup object.
	 * @throws     PropelException
	 */
	public function getAccessGroup(PDO $con = null)
	{
		if ($this->aAccessGroup === null && ($this->group_id !== null)) {
			$this->aAccessGroup = AccessGroupPeer::retrieveByPK($this->group_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aAccessGroup->addIpMasks($this);
			 */
		}
		return $this->aAccessGroup;
	}

} // BaseIpMask
