<?php

/**
 * Base class that represents a row from the 'ccl_map' table.
 *
 * CCL Mapping
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * Mon Nov 12 15:49:39 2007
 *
 * @package    masterkey.om
 */
abstract class BaseCclMap extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        CclMapPeer
	 */
	protected static $peer;


	/**
	 * The value for the ccl_map_id field.
	 * @var        int
	 */
	protected $ccl_map_id;


	/**
	 * The value for the ccl_map_name field.
	 * @var        string
	 */
	protected $ccl_map_name;

	/**
	 * @var        array Target[] Collection to store aggregation of Target objects.
	 */
	protected $collTargets;

	/**
	 * @var        Criteria The criteria used to select the current contents of collTargets.
	 */
	private $lastTargetCriteria = null;

	/**
	 * @var        array CclSpec[] Collection to store aggregation of CclSpec objects.
	 */
	protected $collCclSpecs;

	/**
	 * @var        Criteria The criteria used to select the current contents of collCclSpecs.
	 */
	private $lastCclSpecCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Get the [ccl_map_id] column value.
	 * CCL map id
		
	 * @return     int
	 */
	public function getCclMapId()
	{

		return $this->ccl_map_id;
	}

	/**
	 * Get the [ccl_map_name] column value.
	 * CCL profile name
		
	 * @return     string
	 */
	public function getCclMapName()
	{

		return $this->ccl_map_name;
	}

	/**
	 * Set the value of [ccl_map_id] column.
	 * CCL map id
	 * @param      int $v new value
	 * @return     void
	 */
	public function setCclMapId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->ccl_map_id !== $v) {
			$this->ccl_map_id = $v;
			$this->modifiedColumns[] = CclMapPeer::CCL_MAP_ID;
		}

	} // setCclMapId()

	/**
	 * Set the value of [ccl_map_name] column.
	 * CCL profile name
	 * @param      string $v new value
	 * @return     void
	 */
	public function setCclMapName($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->ccl_map_name !== $v) {
			$this->ccl_map_name = $v;
			$this->modifiedColumns[] = CclMapPeer::CCL_MAP_NAME;
		}

	} // setCclMapName()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 * 
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default. 
	 * 
	 * @return    boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0)
	{
		try {

			$this->ccl_map_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->ccl_map_name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->resetModified();

			$this->setNew(false);

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 2; // 2 = CclMapPeer::NUM_COLUMNS - CclMapPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating CclMap object", $e);
		}
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CclMapPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			CclMapPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.  If the object is new,
	 * it inserts it; otherwise an update is performed.  This method
	 * wraps the doSave() worker method in a transaction.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CclMapPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			$affectedRows = $this->doSave($con);
			$con->commit();
			CclMapPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = CclMapPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setCclMapId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += CclMapPeer::doUpdate($this, $con);
				}
				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collTargets !== null) {
				foreach ($this->collTargets as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collCclSpecs !== null) {
				foreach ($this->collCclSpecs as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = CclMapPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collTargets !== null) {
					foreach ($this->collTargets as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collCclSpecs !== null) {
					foreach ($this->collCclSpecs as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(CclMapPeer::DATABASE_NAME);

		if ($this->isColumnModified(CclMapPeer::CCL_MAP_ID)) $criteria->add(CclMapPeer::CCL_MAP_ID, $this->ccl_map_id);
		if ($this->isColumnModified(CclMapPeer::CCL_MAP_NAME)) $criteria->add(CclMapPeer::CCL_MAP_NAME, $this->ccl_map_name);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(CclMapPeer::DATABASE_NAME);

		$criteria->add(CclMapPeer::CCL_MAP_ID, $this->ccl_map_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getCclMapId();
	}

	/**
	 * Generic method to set the primary key (ccl_map_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setCclMapId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of CclMap (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCclMapName($this->ccl_map_name);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getTargets() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
				$copyObj->addTarget($relObj->copy($deepCopy));
			}
			}

			foreach ($this->getCclSpecs() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
				$copyObj->addCclSpec($relObj->copy($deepCopy));
			}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setCclMapId(NULL); // this is a pkey column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     CclMap Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     CclMapPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new CclMapPeer();
		}
		return self::$peer;
	}

	/**
	 * Temporary storage of collTargets to save a possible db hit in
	 * the event objects are add to the collection, but the
	 * complete collection is never requested.
	 *
	 * @return     void
	 * @deprecated - This method will be removed in 2.0 since arrays
	 *				are automatically initialized in the addTargets() method.
	 * @see        addTargets()
	 */
	public function initTargets()
	{
		if ($this->collTargets === null) {
			$this->collTargets = array();
		}
	}

	/**
	 * Gets an array of  objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this CclMap has previously been saved, it will retrieve
	 * related Targets from storage. If this CclMap is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PDO $con
	 * @param      Criteria $criteria
	 * @return     array []
	 * @throws     PropelException
	 */
	public function getTargets($criteria = null, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTargets === null) {
			if ($this->isNew()) {
			   $this->collTargets = array();
			} else {

				$criteria->add(TargetPeer::CCL_MAP_ID, $this->getCclMapId());

				TargetPeer::addSelectColumns($criteria);
				$this->collTargets = TargetPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(TargetPeer::CCL_MAP_ID, $this->getCclMapId());

				TargetPeer::addSelectColumns($criteria);
				if (!isset($this->lastTargetCriteria) || !$this->lastTargetCriteria->equals($criteria)) {
					$this->collTargets = TargetPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastTargetCriteria = $criteria;
		return $this->collTargets;
	}

	/**
	 * Returns the number of related Targets.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PDO $con
	 * @throws     PropelException
	 */
	public function countTargets($criteria = null, $distinct = false, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(TargetPeer::CCL_MAP_ID, $this->getCclMapId());

		return TargetPeer::doCount($criteria, $distinct, $con);
	}

	/**
	 * Method called to associate a Target object to this object
	 * through the Target foreign key attribute.
	 *
	 * @param      Target $l Target
	 * @return     void
	 * @throws     PropelException
	 */
	public function addTarget(Target $l)
	{
		$this->collTargets = (array) $this->collTargets;
		array_push($this->collTargets, $l);
		$l->setCclMap($this);
	}

	/**
	 * Temporary storage of collCclSpecs to save a possible db hit in
	 * the event objects are add to the collection, but the
	 * complete collection is never requested.
	 *
	 * @return     void
	 * @deprecated - This method will be removed in 2.0 since arrays
	 *				are automatically initialized in the addCclSpecs() method.
	 * @see        addCclSpecs()
	 */
	public function initCclSpecs()
	{
		if ($this->collCclSpecs === null) {
			$this->collCclSpecs = array();
		}
	}

	/**
	 * Gets an array of  objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this CclMap has previously been saved, it will retrieve
	 * related CclSpecs from storage. If this CclMap is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PDO $con
	 * @param      Criteria $criteria
	 * @return     array []
	 * @throws     PropelException
	 */
	public function getCclSpecs($criteria = null, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCclSpecs === null) {
			if ($this->isNew()) {
			   $this->collCclSpecs = array();
			} else {

				$criteria->add(CclSpecPeer::CCL_MAP_ID, $this->getCclMapId());

				CclSpecPeer::addSelectColumns($criteria);
				$this->collCclSpecs = CclSpecPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(CclSpecPeer::CCL_MAP_ID, $this->getCclMapId());

				CclSpecPeer::addSelectColumns($criteria);
				if (!isset($this->lastCclSpecCriteria) || !$this->lastCclSpecCriteria->equals($criteria)) {
					$this->collCclSpecs = CclSpecPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCclSpecCriteria = $criteria;
		return $this->collCclSpecs;
	}

	/**
	 * Returns the number of related CclSpecs.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PDO $con
	 * @throws     PropelException
	 */
	public function countCclSpecs($criteria = null, $distinct = false, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CclSpecPeer::CCL_MAP_ID, $this->getCclMapId());

		return CclSpecPeer::doCount($criteria, $distinct, $con);
	}

	/**
	 * Method called to associate a CclSpec object to this object
	 * through the CclSpec foreign key attribute.
	 *
	 * @param      CclSpec $l CclSpec
	 * @return     void
	 * @throws     PropelException
	 */
	public function addCclSpec(CclSpec $l)
	{
		$this->collCclSpecs = (array) $this->collCclSpecs;
		array_push($this->collCclSpecs, $l);
		$l->setCclMap($this);
	}

} // BaseCclMap
