<?php
class TargetData extends DOMDocument
{
    public function __construct($targetId)
    {
        $target = TargetPeer::retrieveByPK($targetId);

        parent::__construct('1.0', 'utf-8');
        $root = $this->appendChild( new DOMElement('target') );

        $root->setAttribute('name', $target->getTargetName());
        $root->setAttribute('connstring', $target->getConnString());
        $root->setAttribute('rec_enc', $target->getRecEnc());
        $root->setAttribute('query_enc', $target->getQueryEnc());
        $root->setAttribute('req_syn', $target->getReqSyn());
        $root->setAttribute('xslt', $target->getXslt());
        $root->setAttribute('cclmap_id', $target->getCclmapId());
        $root->setAttribute('holding_type', $target->getHoldingType());
        $root->setAttribute('holding_xsl', $target->getHoldingXsl());
        $root->setAttribute('url_recipe', $target->getUrlRecipe());
        $root->setAttribute('proxy_conn_string', $target->getProxyConnString());
        $root->setAttribute('ill_email', $target->getIllEmail());
    }
}
