<?php

/* $Id: OaiTaskList.class.php,v 1.7 2007-10-16 10:30:08 jakub Exp $
 * ------------------------------------------------------------------
 * This class implements methods for looking up tasks in the task dir
 */

require_once('OaiTask.class.php');

class OaiTaskList
{
    private $taskDir;

    public function __construct ($task_dir = '')
    {
        if ( strlen($task_dir) )
            $this->taskDir = $task_dir;
        else
            $this->taskDir = dirname(__FILE__) . '/../../../var/oai';
    }

    private function getTaskByFile ($file)
    {
        return new OaiTask(array('task_file' => $this->taskDir . '/' . $file) );
    }


    public function getTaskById ($id)
    {
        return $this->getTaskByFile($id);
    }


    public function createNew ($data)
    {
        return new OaiTask( array('task_dir'        => $this->taskDir,
                                  'data'            => $data) );
    }


    public function getTasks ($date = '')
    { 
        $dh = opendir($this->taskDir);
        $ret = array();

        while ( false !== ($file = readdir($dh)) ) {
            if ( preg_match('/\.xml$/', $file) ) {
                
                $parsed =  $this->getTaskByFile($file);
                $title = 
                    $parsed->getElementsByTagName('title')->item(0)->nodeValue;
                
                $ret[$title] = array( "id" => $file,
                                    "doc" => $parsed );
            }
        }

        uksort($ret, 'strnatcasecmp');

        return $ret;
    }


    public function getTasksXML ($date = '')
    {
        $tasks = $this->getTasks($date);
        $doc = new DOMDocument();
        $root = $doc->createElement('tasklist');
        $doc->appendChild($root);

        foreach ($tasks as $title => $entry ) {
            $t_root = $entry['doc']->documentElement;
            $t_id = $entry['id'];
            
            $task = $doc->createElement('task');
            $task->setAttribute('id', $t_id);

            foreach ($t_root->childNodes as $kid) {
                if ( $kid->nodeType == XML_ELEMENT_NODE ) {
                    $task->setAttribute($kid->nodeName, $kid->textContent);
                }
            }

            $root->appendChild($task);
        }

        return $doc;
    }
}
