
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- access_group
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `access_group`;


CREATE TABLE `access_group`
(
	`group_id` INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'Group Id',
	`group_name` VARCHAR(255)  NOT NULL COMMENT 'Group name',
	`logo` VARCHAR(4096) COMMENT 'group logo',
	PRIMARY KEY (`group_id`)
)Type=INNODB COMMENT='Group of users';

#-----------------------------------------------------------------------------
#-- user
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `user`;


CREATE TABLE `user`
(
	`user_id` INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'User Id',
	`user_name` VARCHAR(255) COMMENT 'User full name',
	`institution` VARCHAR(255) COMMENT 'Encrypted user password',
	`email` VARCHAR(255) COMMENT 'Encrypted user password',
	`login` VARCHAR(255)  NOT NULL COMMENT 'Login name',
	`enc_pass` VARCHAR(255)  NOT NULL COMMENT 'Encrypted user password',
	`sel_enabled` INTEGER default 0 COMMENT 'Remember last selection',
	`records_page` INTEGER default 0,
	`thumbs` INTEGER default 0,
	`type` INTEGER default 0,
	`state` INTEGER default 0,
	`selection` VARCHAR(4096),
	`ourl_resolver` VARCHAR(4096) COMMENT 'OpenURL resolver address',
	`group_id` INTEGER  NOT NULL,
	PRIMARY KEY (`user_id`),
	INDEX `user_FI_1` (`group_id`),
	CONSTRAINT `user_FK_1`
		FOREIGN KEY (`group_id`)
		REFERENCES `access_group` (`group_id`)
)Type=INNODB COMMENT='Users';

#-----------------------------------------------------------------------------
#-- ip_mask
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `ip_mask`;


CREATE TABLE `ip_mask`
(
	`mask_id` INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'Group Id',
	`mask_name` VARCHAR(255)  NOT NULL COMMENT 'IP range name',
	`mask_lower` BIGINT  NOT NULL COMMENT 'Lower range value',
	`mask_upper` BIGINT  NOT NULL COMMENT 'Upper value',
	`group_id` INTEGER  NOT NULL,
	PRIMARY KEY (`mask_id`),
	INDEX `ip_mask_FI_1` (`group_id`),
	CONSTRAINT `ip_mask_FK_1`
		FOREIGN KEY (`group_id`)
		REFERENCES `access_group` (`group_id`)
)Type=INNODB COMMENT='Ip masks';

#-----------------------------------------------------------------------------
#-- target
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `target`;


CREATE TABLE `target`
(
	`target_id` INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'Z39.50 target Id',
	`target_name` VARCHAR(255)  NOT NULL COMMENT 'Target name',
	`conn_string` VARCHAR(255)  NOT NULL COMMENT 'Z39.50 connection string',
	`rec_enc` VARCHAR(4096)  NOT NULL COMMENT 'Record encoding',
	`query_enc` VARCHAR(255)  NOT NULL COMMENT 'Query encoding',
	`req_syn` VARCHAR(255)  NOT NULL COMMENT 'Request syntax',
	`xslt` VARCHAR(255) COMMENT 'XSL Transform for record normalization',
	`ccl_map_id` INTEGER  NOT NULL COMMENT 'CCL map id',
	`holding_type` INTEGER COMMENT 'Holding type',
	`holding_xsl` VARCHAR(255) COMMENT 'Holding extraction stylesheet',
	`url_recipe` VARCHAR(4096) COMMENT 'Local system URL recipe',
	`proxy_conn_string` VARCHAR(4096) COMMENT 'Optional Z39.50 proxy',
	`ill_email` VARCHAR(4096) COMMENT 'Optional email used for ILL',
	PRIMARY KEY (`target_id`),
	INDEX `target_FI_1` (`ccl_map_id`),
	CONSTRAINT `target_FK_1`
		FOREIGN KEY (`ccl_map_id`)
		REFERENCES `ccl_map` (`ccl_map_id`)
)Type=INNODB COMMENT='Target table';

#-----------------------------------------------------------------------------
#-- z_auth
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `z_auth`;


CREATE TABLE `z_auth`
(
	`target_id` INTEGER  NOT NULL,
	`group_id` INTEGER  NOT NULL,
	`z_user` VARCHAR(255) COMMENT 'Auth login',
	`z_pass` VARCHAR(255) COMMENT 'Auth password',
	`z_group` VARCHAR(255) COMMENT 'Auth group',
	PRIMARY KEY (`target_id`,`group_id`),
	CONSTRAINT `z_auth_FK_1`
		FOREIGN KEY (`target_id`)
		REFERENCES `target` (`target_id`),
	INDEX `z_auth_FI_2` (`group_id`),
	CONSTRAINT `z_auth_FK_2`
		FOREIGN KEY (`group_id`)
		REFERENCES `access_group` (`group_id`)
)Type=INNODB COMMENT='many 2 many rel. between targets and groups';

#-----------------------------------------------------------------------------
#-- ccl_map
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `ccl_map`;


CREATE TABLE `ccl_map`
(
	`ccl_map_id` INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'CCL map id',
	`ccl_map_name` VARCHAR(255)  NOT NULL COMMENT 'CCL profile name',
	PRIMARY KEY (`ccl_map_id`)
)Type=INNODB COMMENT='CCL Mapping';

#-----------------------------------------------------------------------------
#-- ccl_spec
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `ccl_spec`;


CREATE TABLE `ccl_spec`
(
	`ccl_spec_id` INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'Specificiation ID',
	`ccl_map_id` INTEGER  NOT NULL COMMENT 'Relation to cclmap table',
	`ccl_qual` VARCHAR(255)  NOT NULL COMMENT 'CCL qualifier',
	`pqf` VARCHAR(255)  NOT NULL COMMENT 'PQF string',
	PRIMARY KEY (`ccl_spec_id`),
	INDEX `ccl_spec_FI_1` (`ccl_map_id`),
	CONSTRAINT `ccl_spec_FK_1`
		FOREIGN KEY (`ccl_map_id`)
		REFERENCES `ccl_map` (`ccl_map_id`)
)Type=INNODB COMMENT='CCL to PQF mapping specificiations';

#-----------------------------------------------------------------------------
#-- category
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `category`;


CREATE TABLE `category`
(
	`cat_id` INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'Category Id',
	`cat_name` VARCHAR(255)  NOT NULL COMMENT 'Category name',
	`parent_id` INTEGER default 0 NOT NULL COMMENT 'Parent category Id',
	PRIMARY KEY (`cat_id`),
	INDEX `category_FI_1` (`parent_id`),
	CONSTRAINT `category_FK_1`
		FOREIGN KEY (`parent_id`)
		REFERENCES `category` (`cat_id`)
)Type=INNODB COMMENT='Category table';

#-----------------------------------------------------------------------------
#-- seed
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `seed`;


CREATE TABLE `seed`
(
	`seed_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`seed_value` VARCHAR(255)  NOT NULL,
	PRIMARY KEY (`seed_id`)
)Type=INNODB COMMENT='Seed table';

#-----------------------------------------------------------------------------
#-- target_ref_cat
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `target_ref_cat`;


CREATE TABLE `target_ref_cat`
(
	`target_id` INTEGER  NOT NULL,
	`cat_id` INTEGER  NOT NULL,
	PRIMARY KEY (`target_id`,`cat_id`),
	CONSTRAINT `target_ref_cat_FK_1`
		FOREIGN KEY (`target_id`)
		REFERENCES `target` (`target_id`),
	INDEX `target_ref_cat_FI_2` (`cat_id`),
	CONSTRAINT `target_ref_cat_FK_2`
		FOREIGN KEY (`cat_id`)
		REFERENCES `category` (`cat_id`)
)Type=INNODB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
